local assets=
{
	Asset("ANIM", "anim/qmb.zip"),
	Asset("ANIM", "anim/swap_qmb.zip"),
        Asset("IMAGE", "images/inventoryimages/qmb.tex"),
	Asset("ATLAS", "images/inventoryimages/qmb.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onattack_qmb(inst, attacker, target)
    attacker.components.hunger:DoDelta(-2)
    attacker.components.sanity:DoDelta(-1)
    local pos = Vector3(target.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3)
    	for k,v in pairs(ents) do
	    if v == target and v.components.locomotor then
            	if v:HasTag("monster") then
		v.components.health:DoDelta(-15)
		local pt = Point(v.Transform:GetWorldPosition())
            	local breaking = SpawnPrefab("ground_l_breaking")
            	breaking.Transform:SetPosition(pt.x, 0, pt.z)
		end
	    local pt11 = attacker:GetPosition()
            local pt12 = target:GetPosition()
            target.Transform:SetPosition((pt12.x-pt11.x)*0.2+pt12.x, 0, (pt12.z-pt11.z)*0.2+pt12.z)
	    elseif v.components.combat and v.components.health and not v.components.health:IsDead() and not v:HasTag("player") then
	   	 	if v:HasTag("monster") then
		              v.components.health:DoDelta(-15)
			end
		v.components.health:DoDelta(-35)
		local pt = Point(v.Transform:GetWorldPosition())
            	local breaking = SpawnPrefab("ground_l_breaking")
            	breaking.Transform:SetPosition(pt.x, 0, pt.z)
	    	local pt13 = attacker:GetPosition()
            	local pt14 = v:GetPosition()
            	v.Transform:SetPosition((pt14.x-pt13.x)*0.2+pt14.x, 0, (pt14.z-pt13.z)*0.2+pt14.z)
  	    end
	end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_qmb", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	if owner.components.hunger then
        owner.components.hunger.burnrate = TUNING.ARMORSLURPER_SLOW_HUNGER
        end

end

local function onattack_qmb(inst, attacker, data)
	if attacker then
		SpawnPrefab("lightning").Transform:SetPosition(inst:GetPosition():Get())
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function doBlindEffect(target)
    local size = 1
    if target:HasTag("smallcreature") then
        size = 0
    elseif target:HasTag("largecreature") then
        size = 2
    end

    local fx = SpawnPrefab("lightning")
    fx.entity:SetParent(target.entity)
    fx.Transform:SetPosition(0, size, 0)
    target.blindEffect = fx
end
local function doBlindEffectEndTask(target)
    if target.blindEffectEndTask ~= nil then
        target.blindEffectEndTask:Cancel()
    end

    local time = 3
    if target.components.health then
        if target.components.health.currenthealth <= 0 then
            time = 0
        end
    end

    target.blindEffectEndTask = target:DoTaskInTime(time, function(target)
        if target.blindEffect ~= nil then
            target.blindEffect:Remove()
            target.blindEffect = nil
        end
    end, target)
end


local function onattack_qmb(inst, atker, target, skipsanity)

    -- ֥饤ɄϴʸĤΈϤΤ
    

        if target.blindEffect ~= nil then
           
            doBlindEffectEndTask(target)
            return
        end

   
        doBlindEffect(target)
        doBlindEffectEndTask(target)

  

    -- ؤǤ⹥Ĥʹʻ؏ͳ褦ˤ
    

end



local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("carrot")
    anim:SetBuild("qmb")
    anim:PlayAnimation("idle")  
    
    -------        
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.CANE_DAMAGE)
    inst.components.weapon:SetDamage(35)
     inst.components.weapon:SetRange(4, 4)
    inst.components.weapon:SetOnAttack(onattack_qmb)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/qmb.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.walkspeedmult = 3
    inst.components.equippable.dapperness = -TUNING.DAPPERNESS_HUGE

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 8

    return inst
end

return Prefab( "common/inventory/qmb", fn, assets) 
